<?php
// api_clients.php
require_once __DIR__ . '/config.php';
require_once __DIR__ . '/auth.php';

require_login();

$action = $_POST['action'] ?? '';

try {
    if ($action === 'list') {
        $rows = pdo()->query("SELECT * FROM rc_clients ORDER BY id DESC")->fetchAll();
        json_out(["ok"=>true, "data"=>$rows]);
    }

    if (in_array($action, ['create','update','delete'], true)) {
        csrf_check();
    }

    if ($action === 'create') {
        $sql = "INSERT INTO rc_clients (sede, protrack_account, protrack_password, rc_userId, rc_password, customer_id, customer_name, is_active)
                VALUES (:sede,:pa,:pp,:ru,:rp,:cid,:cname,:active)";
        $st = pdo()->prepare($sql);
        $st->execute([
            ":sede"   => $_POST['sede'] ?? 'QRO',
            ":pa"     => trim($_POST['protrack_account'] ?? ''),
            ":pp"     => trim($_POST['protrack_password'] ?? ''),
            ":ru"     => trim($_POST['rc_userId'] ?? ''),
            ":rp"     => trim($_POST['rc_password'] ?? ''),
            ":cid"    => trim($_POST['customer_id'] ?? ''),
            ":cname"  => trim($_POST['customer_name'] ?? ''),
            ":active" => (int)($_POST['is_active'] ?? 1),
        ]);
        json_out(["ok"=>true, "msg"=>"Creado"]);
    }

    if ($action === 'update') {
        $id = (int)($_POST['id'] ?? 0);
        if ($id <= 0) json_out(["ok"=>false,"msg"=>"ID inválido"], 400);

        $sql = "UPDATE rc_clients SET
                  sede=:sede,
                  protrack_account=:pa, protrack_password=:pp,
                  rc_userId=:ru, rc_password=:rp,
                  customer_id=:cid, customer_name=:cname,
                  is_active=:active
                WHERE id=:id";
        $st = pdo()->prepare($sql);
        $st->execute([
            ":sede"   => $_POST['sede'] ?? 'QRO',
            ":pa"     => trim($_POST['protrack_account'] ?? ''),
            ":pp"     => trim($_POST['protrack_password'] ?? ''),
            ":ru"     => trim($_POST['rc_userId'] ?? ''),
            ":rp"     => trim($_POST['rc_password'] ?? ''),
            ":cid"    => trim($_POST['customer_id'] ?? ''),
            ":cname"  => trim($_POST['customer_name'] ?? ''),
            ":active" => (int)($_POST['is_active'] ?? 1),
            ":id"     => $id,
        ]);
        json_out(["ok"=>true, "msg"=>"Actualizado"]);
    }

    if ($action === 'delete') {
        $id = (int)($_POST['id'] ?? 0);
        if ($id <= 0) json_out(["ok"=>false,"msg"=>"ID inválido"], 400);
        $st = pdo()->prepare("DELETE FROM rc_clients WHERE id=?");
        $st->execute([$id]);
        json_out(["ok"=>true, "msg"=>"Eliminado"]);
    }

    json_out(["ok"=>false, "msg"=>"Acción no válida"], 400);

} catch (Throwable $e) {
    json_out(["ok"=>false, "msg"=>$e->getMessage()], 500);
}