<?php
// clients.php
require_once __DIR__ . '/config.php';
require_once __DIR__ . '/auth.php';

if (isset($_GET['logout'])) logout();
if (isset($_GET['login'])) { handle_login(); } // procesa POST si viene

ensure_session();
$csrf = csrf_token();

$loginMode = isset($_GET['login']);
$loginErr = $_SESSION['login_err'] ?? '';
unset($_SESSION['login_err']);

if (!$loginMode) require_login();
?>
<!doctype html>
<html lang="es" data-bs-theme="dark">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>RC ↔ Protrack | Clientes</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">

  <style>
    :root{
      --dim: 0.22; /* 0 = más claro, 1 = más oscuro */
      --bg:   hsl(215 30% calc(10% + (18% * (1 - var(--dim)))));
      --card: hsl(215 25% calc(13% + (18% * (1 - var(--dim)))));
      --bd:   rgba(255,255,255, calc(0.10 + (0.10 * (1 - var(--dim)))));
      --tx:   rgba(255,255,255, calc(0.82 + (0.12 * (1 - var(--dim)))));
      --mut:  rgba(255,255,255, calc(0.55 + (0.18 * (1 - var(--dim)))));
    }

    body{
      background: var(--bg) !important;
      color: var(--tx) !important;
    }

    .card{
      background: var(--card) !important;
      border: 1px solid var(--bd) !important;
    }

    .muted{ color: var(--mut) !important; }

    .table{ --bs-table-bg: transparent; }

    .table thead th{ color: rgba(255,255,255,.8); }

    .mono{
      font-family: ui-monospace, SFMono-Regular, Menlo, Monaco, Consolas,
                   "Liberation Mono", "Courier New", monospace;
    }
  </style>
</head>

<body>
<div class="container py-4">

<?php if ($loginMode): ?>

  <div class="row justify-content-center">
    <div class="col-12 col-md-6 col-lg-4">
      <div class="card shadow-sm">
        <div class="card-body p-4">
          <h4 class="mb-1">Acceso</h4>
          <div class="muted mb-3">Panel RC ↔ Protrack</div>

          <?php if ($loginErr): ?>
            <div class="alert alert-danger"><?= h($loginErr) ?></div>
          <?php endif; ?>

          <form method="post" action="clients.php?login=1">
            <div class="mb-2">
              <label class="form-label">Usuario</label>
              <input class="form-control" name="user" autocomplete="username" required>
            </div>
            <div class="mb-3">
              <label class="form-label">Contraseña</label>
              <input class="form-control" type="password" name="pass" autocomplete="current-password" required>
            </div>
            <button class="btn btn-primary w-100">Entrar</button>
          </form>
        </div>
      </div>
      <div class="text-center muted mt-3 small">Modo oscuro + Bootstrap 5</div>
    </div>
  </div>

<?php else: ?>

  <div class="d-flex align-items-center justify-content-between mb-3">
    <div>
      <h3 class="mb-0">Clientes Recurso Confiable</h3>

      <div class="d-flex align-items-center gap-2 mt-2">
        <span class="muted small">Brillo</span>
        <input id="dimSlider" type="range" min="0" max="100" value="22"
               class="form-range" style="width:160px">
        <span class="muted small" id="dimLbl"></span>
      </div>

      <div class="muted mt-1">Alta / editar / eliminar + sede (QRO / Pach.)</div>
    </div>

    <div class="d-flex gap-2">
      <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#modalAdd">+ Alta cliente</button>
      <a class="btn btn-outline-danger" href="clients.php?logout=1">Salir</a>
    </div>
  </div>

  <div class="card shadow-sm">
    <div class="card-body">

      <div class="row g-2 mb-2">
        <div class="col-12 col-md-5">
          <input id="searchBox" class="form-control"
                 placeholder="Buscar por customer id, customer name, protrack account, rc userId...">
        </div>
        <div class="col-12 col-md-3">
          <select id="filterSede" class="form-select">
            <option value="">Todas las sedes</option>
            <option value="QRO">QRO</option>
            <option value="PACH">PACH</option>
          </select>
        </div>
        <div class="col-12 col-md-4 d-flex align-items-center justify-content-md-end">
          <div class="muted small" id="countLbl"></div>
        </div>
      </div>

      <div class="table-responsive">
        <table class="table table-dark table-hover align-middle mb-0" id="tbl">
          <thead>
            <tr>
              <th>ID</th>
              <th>Sede</th>
              <th>Cliente</th>
              <th>RC userId</th>
              <th>Cuenta Protrack </th>
              <th>Activo</th>
              <th class="text-end">Acciones</th>
            </tr>
          </thead>
          <tbody id="tbody">
            <tr><td colspan="7" class="muted">Cargando...</td></tr>
          </tbody>
        </table>
      </div>

    </div>
  </div>

  <!-- Modal Alta -->
  <div class="modal fade" id="modalAdd" tabindex="-1">
    <div class="modal-dialog modal-lg modal-dialog-centered">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title">Alta de cliente</h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
        </div>

        <form id="frmAdd">
          <div class="modal-body">
            <input type="hidden" name="csrf" value="<?= h($csrf) ?>">
            <div class="row g-3">

              <div class="col-md-3">
                <label class="form-label">Sede</label>
                <select class="form-select" name="sede" required>
                  <option value="QRO">QRO</option>
                  <option value="PACH">PACH</option>
                </select>
              </div>

              <div class="col-md-4">
                <label class="form-label">Customer ID (RC)</label>
                <input class="form-control mono" name="customer_id" required>
              </div>

              <div class="col-md-5">
                <label class="form-label">Customer Name (RC)</label>
                <input class="form-control" name="customer_name" required>
              </div>

              <div class="col-md-6">
                <label class="form-label">RC userId</label>
                <input class="form-control mono" name="rc_userId" required>
              </div>

              <div class="col-md-6">
                <label class="form-label">RC password</label>
                <input class="form-control mono" name="rc_password" required>
              </div>

              <div class="col-md-6">
                <label class="form-label">Protrack account</label>
                <input class="form-control mono" name="protrack_account" required>
              </div>

              <div class="col-md-6">
                <label class="form-label">Protrack password</label>
                <input class="form-control mono" name="protrack_password" required>
              </div>

              <div class="col-md-3">
                <label class="form-label">Activo</label>
                <select class="form-select" name="is_active">
                  <option value="1" selected>Si</option>
                  <option value="0">No</option>
                </select>
              </div>

              <div class="col-md-9">
                <div class="muted small pt-4">
                  Tip: el runner lee <b>solo activos</b>. “Probar” ejecuta el cliente para validar que está jalando.
                </div>
              </div>

            </div>
          </div>

          <div class="modal-footer">
            <button class="btn btn-outline-secondary" data-bs-dismiss="modal" type="button">Cancelar</button>
            <button class="btn btn-primary">Guardar</button>
          </div>
        </form>

      </div>
    </div>
  </div>

  <!-- Modal Editar -->
  <div class="modal fade" id="modalEdit" tabindex="-1">
    <div class="modal-dialog modal-lg modal-dialog-centered">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title">Editar cliente</h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
        </div>

        <form id="frmEdit">
          <div class="modal-body">
            <input type="hidden" name="csrf" value="<?= h($csrf) ?>">
            <input type="hidden" name="id" id="edit_id">

            <div class="row g-3">
              <div class="col-md-3">
                <label class="form-label">Sede</label>
                <select class="form-select" name="sede" id="edit_sede" required>
                  <option value="QRO">QRO</option>
                  <option value="PACH">PACH</option>
                </select>
              </div>

              <div class="col-md-4">
                <label class="form-label">Customer ID</label>
                <input class="form-control mono" name="customer_id" id="edit_customer_id" required>
              </div>

              <div class="col-md-5">
                <label class="form-label">Customer Name</label>
                <input class="form-control" name="customer_name" id="edit_customer_name" required>
              </div>

              <div class="col-md-6">
                <label class="form-label">RC userId</label>
                <input class="form-control mono" name="rc_userId" id="edit_rc_userId" required>
              </div>

              <div class="col-md-6">
                <label class="form-label">RC password</label>
                <input class="form-control mono" name="rc_password" id="edit_rc_password" required>
              </div>

              <div class="col-md-6">
                <label class="form-label">Protrack account</label>
                <input class="form-control mono" name="protrack_account" id="edit_protrack_account" required>
              </div>

              <div class="col-md-6">
                <label class="form-label">Protrack password</label>
                <input class="form-control mono" name="protrack_password" id="edit_protrack_password" required>
              </div>

              <div class="col-md-3">
                <label class="form-label">Activo</label>
                <select class="form-select" name="is_active" id="edit_is_active">
                  <option value="1">Si</option>
                  <option value="0">No</option>
                </select>
              </div>
            </div>

          </div>

          <div class="modal-footer">
            <button class="btn btn-outline-secondary" data-bs-dismiss="modal" type="button">Cerrar</button>
            <button class="btn btn-primary">Guardar cambios</button>
          </div>
        </form>

      </div>
    </div>
  </div>

  <!-- Toast -->
  <div class="position-fixed bottom-0 end-0 p-3" style="z-index: 9999">
    <div id="toast" class="toast" role="alert">
      <div class="toast-header">
        <strong class="me-auto">Panel</strong>
        <small class="muted">ahora</small>
        <button type="button" class="btn-close" data-bs-dismiss="toast"></button>
      </div>
      <div class="toast-body" id="toastBody">Ok</div>
    </div>
  </div>

<?php endif; ?>

</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>

<?php if (!$loginMode): ?>
<script>
  const toastEl = document.getElementById('toast');
  const toast = new bootstrap.Toast(toastEl, { delay: 2400 });
  const toastBody = document.getElementById('toastBody');

  function showToast(msg){
    toastBody.textContent = msg;
    toast.show();
  }

  async function api(formData){
    const r = await fetch('api_clients.php', { method:'POST', body: formData });
    const j = await r.json();
    if(!j.ok) throw new Error(j.msg || 'Error');
    return j;
  }

  function escapeHtml(s){
    return String(s ?? '').replace(/[&<>"']/g, (m)=>({
      "&":"&amp;","<":"&lt;",">":"&gt;",'"':"&quot;","'":"&#039;"
    }[m]));
  }

  // ===== DIMMER =====
  const dimSlider = document.getElementById('dimSlider');
  const dimLbl = document.getElementById('dimLbl');
  const dimKey = 'ui_dim';

  function applyDim(v){
    const d = Math.min(100, Math.max(0, Number(v))) / 100; // 0..1
    document.documentElement.style.setProperty('--dim', d.toString());
    localStorage.setItem(dimKey, String(v));
    if(dimLbl) dimLbl.textContent = `${v}%`;
  }

  if(dimSlider){
    const saved = localStorage.getItem(dimKey);
    if(saved !== null){ dimSlider.value = saved; }
    applyDim(dimSlider.value);
    dimSlider.addEventListener('input', e => applyDim(e.target.value));
  }

  // ===== SEARCH/FILTER =====
  let CLIENTS = [];

  function matches(c, q){
    q = (q || '').toLowerCase().trim();
    if(!q) return true;
    const hay = [
      c.customer_id, c.customer_name, c.rc_userId, c.protrack_account, c.sede, c.id
    ].join(' ').toLowerCase();
    return hay.includes(q);
  }

  function renderClients(){
    const tb = document.getElementById('tbody');
    const q = (document.getElementById('searchBox')?.value || '');
    const sede = (document.getElementById('filterSede')?.value || '');

    const filtered = CLIENTS.filter(c => {
      if(sede && c.sede !== sede) return false;
      return matches(c, q);
    });

    const countLbl = document.getElementById('countLbl');
    if(countLbl) countLbl.textContent = `Mostrando ${filtered.length} de ${CLIENTS.length}`;

    if(!filtered.length){
      tb.innerHTML = `<tr><td colspan="7" class="muted">Sin resultados</td></tr>`;
      return;
    }

    tb.innerHTML = filtered.map(c => `
      <tr>
        <td class="mono">${c.id}</td>
        <td><span class="badge text-bg-secondary">${escapeHtml(c.sede)}</span></td>
        <td>
          <div class="mono">${escapeHtml(c.customer_id)}</div>
          <div class="muted small">${escapeHtml(c.customer_name)}</div>
        </td>
        <td class="mono">${escapeHtml(c.rc_userId)}</td>
        <td class="mono">${escapeHtml(c.protrack_account)}</td>
        <td>${c.is_active == 1 ? '<span class="badge text-bg-success">SI</span>' : '<span class="badge text-bg-danger">NO</span>'}</td>
        <td class="text-end">
          <button class="btn btn-sm btn-outline-info" onclick='openEdit(${JSON.stringify(c)})'>Editar</button>
          <button class="btn btn-sm btn-outline-danger" onclick="delClient(${c.id})">Eliminar</button>
          <a class="btn btn-sm btn-outline-warning" href="runner.php?client_id=${c.id}&test=1" target="_blank">Probar</a>
        </td>
      </tr>
    `).join('');
  }

  document.getElementById('searchBox')?.addEventListener('input', renderClients);
  document.getElementById('filterSede')?.addEventListener('change', renderClients);

  async function loadClients(){
    const fd = new FormData();
    fd.append('action','list');
    const j = await api(fd);
    CLIENTS = j.data || [];
    renderClients();
  }

  // ===== CREATE =====
  document.getElementById('frmAdd').addEventListener('submit', async (e)=>{
    e.preventDefault();
    const fd = new FormData(e.target);
    fd.append('action','create');
    try{
      await api(fd);
      showToast('Cliente creado');
      bootstrap.Modal.getInstance(document.getElementById('modalAdd')).hide();
      e.target.reset();
      loadClients();
    }catch(err){ showToast(err.message); }
  });

  // ===== EDIT MODAL =====
  function openEdit(c){
    document.getElementById('edit_id').value = c.id;
    document.getElementById('edit_sede').value = c.sede;
    document.getElementById('edit_customer_id').value = c.customer_id;
    document.getElementById('edit_customer_name').value = c.customer_name;
    document.getElementById('edit_rc_userId').value = c.rc_userId;
    document.getElementById('edit_rc_password').value = c.rc_password;
    document.getElementById('edit_protrack_account').value = c.protrack_account;
    document.getElementById('edit_protrack_password').value = c.protrack_password;
    document.getElementById('edit_is_active').value = c.is_active;
    new bootstrap.Modal(document.getElementById('modalEdit')).show();
  }
  window.openEdit = openEdit; // para onclick inline

  // ===== UPDATE =====
  document.getElementById('frmEdit').addEventListener('submit', async (e)=>{
    e.preventDefault();
    const fd = new FormData(e.target);
    fd.append('action','update');
    try{
      await api(fd);
      showToast('Cliente actualizado');
      bootstrap.Modal.getInstance(document.getElementById('modalEdit')).hide();
      loadClients();
    }catch(err){ showToast(err.message); }
  });

  // ===== DELETE =====
  async function delClient(id){
    if(!confirm('¿Eliminar cliente ID ' + id + '?')) return;
    const fd = new FormData();
    fd.append('action','delete');
    fd.append('id', id);
    fd.append('csrf', <?= json_encode($csrf) ?>);
    try{
      await api(fd);
      showToast('Eliminado');
      loadClients();
    }catch(err){ showToast(err.message); }
  }
  window.delClient = delClient; // para onclick inline

  loadClients();
</script>
<?php endif; ?>

</body>
</html>