<?php
// config.php
declare(strict_types=1);
error_reporting(E_ERROR | E_PARSE);
date_default_timezone_set('Etc/GMT+0');

//modalidad del servicio
$produccion = true;


if ($produccion === true) {
    // PRODUCCIÓN
    $DB_HOST = "db5019886927.hosting-data.io";
    $DB_NAME = "dbs15368501";
    $DB_USER = "dbu3839219";
    $DB_PASS = "gps2026hunter";
} else {
    // TEST / LOCAL
    $DB_HOST = "localhost";
    $DB_NAME = "integraciones_rc";
    $DB_USER = "root";
    $DB_PASS = "";
}




function pdo(): PDO {
    static $pdo = null;
    if ($pdo) return $pdo;

    $dsn = "mysql:host=" . DB_HOST . ";dbname=" . DB_NAME . ";charset=utf8mb4";
    $pdo = new PDO($dsn, DB_USER, DB_PASS, [
        PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
        PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC
    ]);
    return $pdo;
}

function h(string $s): string { return htmlspecialchars($s, ENT_QUOTES, 'UTF-8'); }

function json_out(array $data, int $code=200): void {
    http_response_code($code);
    header('Content-Type: application/json; charset=utf-8');
    echo json_encode($data, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES);
    exit;
}

function ensure_session(): void {
    if (session_status() !== PHP_SESSION_ACTIVE) session_start();
}

function csrf_token(): string {
    ensure_session();
    if (empty($_SESSION['csrf'])) $_SESSION['csrf'] = bin2hex(random_bytes(16));
    return $_SESSION['csrf'];
}

function csrf_check(): void {
    ensure_session();
    $t = $_POST['csrf'] ?? '';
    if (!$t || empty($_SESSION['csrf']) || !hash_equals($_SESSION['csrf'], $t)) {
        json_out(["ok"=>false, "msg"=>"CSRF inválido"], 403);
    }
}