<?php
header('Content-Type: application/json');
error_reporting(E_ALL);
set_time_limit(0);
date_default_timezone_set('Etc/GMT+6');

ini_set('display_errors', 0);
ini_set('log_errors', 1);
ini_set('error_log', __DIR__ . '/log_extractor.log');

$time_start = microtime(true);
$horaactual = time();

/* =============================
   Utilidad: Formato DHMS
============================= */
function formatDHMS($seconds)
{
    $dias = floor($seconds / 86400);
    $seconds %= 86400;
    $horas = floor($seconds / 3600);
    $seconds %= 3600;
    $minutos = floor($seconds / 60);
    $segundos = $seconds % 60;

    $res = '';
    if ($dias > 0)    $res .= $dias . 'd ';
    if ($horas > 0)   $res .= $horas . 'h ';
    if ($minutos > 0) $res .= $minutos . 'm ';
    if ($segundos >= 0) $res .= $segundos . 's';
    return trim($res);
}


/* =============================
   MULTICURL → por batch
============================= */
function multiCurlBatch($urls, $batchSize = 40, $timeout = 15)
{
    $responses = [];

    // Dividir en lotes/Chunks
    $chunks = array_chunk($urls, $batchSize, true);

    foreach ($chunks as $chunk) {

        $mh = curl_multi_init();
        $handles = [];

        foreach ($chunk as $key => $url) {

            $ch = curl_init();
            curl_setopt_array($ch, [
                CURLOPT_URL            => $url,
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_TIMEOUT        => $timeout,
            ]);

            curl_multi_add_handle($mh, $ch);
            $handles[$key] = $ch;
        }

        do {
            $status = curl_multi_exec($mh, $running);
            curl_multi_select($mh);
        } while ($running > 0 && $status == CURLM_OK);

        foreach ($handles as $key => $ch) {
            $responses[$key] = curl_multi_getcontent($ch);
            curl_multi_remove_handle($mh, $ch);
            curl_close($ch);
        }

        curl_multi_close($mh);

        // micro-wait opcional
        usleep(200000); // 200ms → ayuda al rate-limit
    }

    return $responses;
}


/* =============================
   DB LOCAL
============================= */
$db_host = 'db5018846436.hosting-data.io';
$db_user = 'dbu974452';
$db_pass = 'testera32.';
$db_name = 'dbs14878639';

$mysqli = new mysqli($db_host, $db_user, $db_pass);
if ($mysqli->connect_errno) {
    error_log('MySQL connect error: ' . $mysqli->connect_error);
    exit(json_encode(["error" => "DB connect error"]));
}

$mysqli->query("CREATE DATABASE IF NOT EXISTS `" . $mysqli->real_escape_string($db_name) . "` 
    CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci");
$mysqli->select_db($db_name);


/* =============================
   WIALON
============================= */

$bloqueomotorres = 0;

include('wialon.php');
$wialon_api = new Wialon();
$token = '8e09eeb5fac1e1591363941a9e574718105E4D90970DDE6ADD8F0A2571182F8B78213A12';

$result = $wialon_api->login($token);
$json = json_decode($result, true);

if (isset($json['error'])) {
    echo WialonError::error($json['error']);
    exit;
}

$mapsid = $json["user"]["id"];

$ecos = $wialon_api->core_search_items(
    '{"spec":{"itemsType":"avl_unit","propName":"sys_name","propValueMask":"*","sortType":"sys_name"}, 
    "force":1,"flags":4611686018427387903,"from":0,"to":0}'
);

$ecosjson = json_decode($ecos);
//var_dump($ecosjson);


/* =============================
   PREPARAMOS GEO URLs
============================= */
$urls = [];
$rawUnits = [];

foreach ($ecosjson->items as $item) {

    $itemId   = $item->id;
    $itemLat  = $item->pos->y ?? 0;
    $itemLon  = $item->pos->x ?? 0;

    $url3 = "https://geocode-maps.wialon.com/hst-api.wialon.com/gis_geocode?"
        . "coords=[{\"lon\":{$itemLon},\"lat\":{$itemLat}}]"
        . "&flags=45321"
        . "&uid={$mapsid}";

    $urls[$itemId] = $url3;
    $rawUnits[$itemId] = $item;
}


/* =============================
   EJECUTAR MULTI-CURL BATCH
============================= */
$geoResponses = multiCurlBatch($urls, 40, 15);


/* =============================
   LOOP DE PROCESO
============================= */
$arrunits = [];

foreach ($rawUnits as $itemId => $item) {

    $itemName = $item->nm;
    $itemLat  = $item->pos->y;
    $itemLon  = $item->pos->x;
    $coordenadas = "{$itemLat},{$itemLon}";
    $itemSpeed = $item->pos->s;
    $unidadtime = $item->pos->t;
  	$unithardware = $item->hw;

    $itemTime = date('Y-m-d H:i:s', $unidadtime);
    $itemdate = date('Y-m-d', $unidadtime);
    $itemTimespec = date('H:i', $unidadtime);

    /* === UBICACIÓN MULTICURL === */
    $resp = $geoResponses[$itemId] ?? "";
    $direccionraw2 = json_decode($resp, true);
    $direccion = $direccionraw2[0] ?? "";


    /* === SENSORES === */
    foreach ($item->sens as $sen) {
        if ($sen->t === "engine operation") {
            $ignicionparam = $sen->p;
        }
        if ($sen->n === "Bloqueo Motor") {
            $bloqueomotorparam = $sen->p;
        }
    }

    /* === IGNICIÓN === */
    $ignicion = boolval($item->prms->{$ignicionparam}->v ?? null);
    $timestampignicionct = $item->prms->{$ignicionparam}->ct ?? null;

    $ignicionlegible  = $timestampignicionct ? date("Y-m-d H:i:s", $timestampignicionct) : null;
    $duracionIgnicion = $timestampignicionct ? formatDHMS($horaactual - $timestampignicionct) : null;
    $ignicionres      = $ignicion ? "ENCENDIDA" : "APAGADA";

    /* === BLOQUEO MOTOR === */
    $bloqueomotor = boolval($item->prms->{$bloqueomotorparam}->v ?? null);
  	$bloqueomotorparam2 = boolval($item->prms->wave1_out_active->v ?? null);
    $timestampbloqueoct = $item->prms->{$bloqueomotorparam}->ct ?? null;

    $bloqueolegible = $timestampbloqueoct ? date("Y-m-d H:i:s", $timestampbloqueoct) : null;
    $duracionBloqueo = $timestampbloqueoct ? formatDHMS($horaactual - $timestampbloqueoct) : null;

	$waveOutValue = $item->prms->wave1_out_id->v ?? null;
  	$waveOutId = $item->prms->wave1_out_active->v ?? null;
  
  
  if($unithardware === 400001047){
    if($bloqueomotor === true){
      $bloqueomotorres = 1;}
    else
    {$bloqueomotorres = 0;}
  }
  
if ($unithardware === 400914897) {

    // Asegurar que existan antes de usarse
    $waveOutValueSafe = isset($waveOutValue) ? (int)$waveOutValue : null;
    $waveOutIdSafe    = isset($waveOutId)   ? (int)$waveOutId   : null;

    if ($waveOutValueSafe === 1 && $waveOutIdSafe === 1) {
        $bloqueomotorres = 1;
    } else {
        $bloqueomotorres = 0;
    }

}
  
  //400001117 meitrack T366
  //400050316 meitrack T633L
  
  //401047520 queckilnk 620 mg
  
  
      
    

//if ($bloqueomotorparam === "wave1_out_id"
  //  && $waveOutValue === 1
   // && $waveOutId === 1
//) {
//    $bloqueomotorres = 1;
//} elseif ($bloqueomotor === true) {
//    $bloqueomotorres = 1;
//} else {
 //   $bloqueomotorres = 0;
//}

  
  /* === BLOQUEO MOTOR — AUTO-DETECCIÓN === */

/*$bloqueomotorres = 0;

// ===== PRIMERO: Buscar waveX_out_id + waveX_out_active =====
$waveActive = false;
$waveId     = false;
$wavePairOK = false;

if (!empty($item->prms) && is_object($item->prms)) {

    foreach ($item->prms as $key => $obj) {

        $v = isset($obj->v) ? (int)$obj->v : null;

        // Buscar waveX_out_id
        if (preg_match('/^wave\d+_out_id$/', $key)) {
            if ($v === 1) {
                $waveId = true;
            }
        }

        // Buscar waveX_out_active
        if (preg_match('/^wave\d+_out_active$/', $key)) {
            if ($v === 1) {
                $waveActive = true;
            }
        }
    }

    // Si ambos están presentes y en 1 → bloqueo
    if ($waveId && $waveActive) {
        $wavePairOK = true;
        $bloqueomotorres = 1;
    }
}

// ===== SEGUNDO: Buscar outN == 1 sólo si NO hubo wave correcto =====
if (!$wavePairOK && !empty($item->prms) && is_object($item->prms)) {

    foreach ($item->prms as $key => $obj) {

        $v = isset($obj->v) ? (int)$obj->v : null;

        if (preg_match('/^out\d+$/', $key) && $v === 1) {
            $bloqueomotorres = 1;
            break;
        }
    }
}*/

// ===== TERCERO: Respaldo a sensor normal =====
//$bloqueomotor = !empty($item->prms->{$bloqueomotorparam}->v);

/*if ($bloqueomotor && $bloqueomotorres === 0) {
    $bloqueomotorres = 0;
}*/

    /* ==== Tiempo sin reporte ==== */
    $diferenciatiempos = $horaactual - $unidadtime;
    $tiempo_sin_reportar = formatDHMS($diferenciatiempos);


    /* INSERT / UPDATE */
    $stmt = $mysqli->prepare("
        INSERT INTO `units`
        (unit_id, unit_name, lat, lon, coordenadas, velocidad, estado, ubicacion, geocercas,
         bloqueomotor, Tiempo_sin_reportar, ignicion, tiempo_ignicion, 
         bloqueo_motor_fecha_legible, duracion_ignicion, duracion_bloqueo_motor, item_time)
        VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)
     ON DUPLICATE KEY UPDATE
    unit_name = VALUES(unit_name),
    lat = VALUES(lat),
    lon = VALUES(lon),
    coordenadas = VALUES(coordenadas),
    velocidad = VALUES(velocidad),
    estado = VALUES(estado),
    ubicacion = VALUES(ubicacion),
    geocercas = COALESCE(VALUES(geocercas), geocercas),
    bloqueomotor = VALUES(bloqueomotor),
    Tiempo_sin_reportar = VALUES(Tiempo_sin_reportar),
    ignicion = VALUES(ignicion),
    tiempo_ignicion = VALUES(tiempo_ignicion),
    bloqueo_motor_fecha_legible = VALUES(bloqueo_motor_fecha_legible),
    duracion_ignicion = VALUES(duracion_ignicion),
    duracion_bloqueo_motor = VALUES(duracion_bloqueo_motor),
    item_time = VALUES(item_time)
    ");

    $estado = $itemSpeed > 0 ? "En transito" : "Detenido";
    $null = null;

    $stmt->bind_param(
        'isddssdssssssssss',
        $itemId,
        $itemName,
        $itemLat,
        $itemLon,
        $coordenadas,
        $itemSpeed,
        $estado,
        $direccion,
        $null,
        $bloqueomotorres,
        $tiempo_sin_reportar,
        $ignicionres,
        $ignicionlegible,
        $bloqueolegible,
        $duracionIgnicion,
        $duracionBloqueo,
        $itemTime
    );

    $stmt->execute();
    $stmt->close();

    $arrunits[] = [
        "Unidad" => $itemName,
        "Fecha"  => $itemdate,
        "itemTime" => $itemTime,
        "Hora" => $itemTimespec,
        "Coordenadas" => $coordenadas,
        "Velocidad" => $itemSpeed,
        "Estado" => $estado,
        "Ubicacion" => $direccion ?? "",
        "bloqueomotor" => $bloqueomotorres,
        "Tiempo_sin_reportar" => $tiempo_sin_reportar,
        "ignicion" => $ignicionres,
        "tiempo_ignicion" => $ignicionlegible,
        "bloqueo_motor_fecha_legible" => $bloqueolegible,
        "duracion_ignicion" => $duracionIgnicion,
        "duracion_bloqueo_motor" => $duracionBloqueo,
    ];
}

$wialon_api->logout();

$time_end = microtime(true);
$arrunits["tiempo_ejecucion_script"] = $time_end - $time_start;

echo json_encode($arrunits);

