<?php
// Backend puro para MySQL (XAMPP)
// Manejo de eventos: ignición y geocercas, sin tocar posición GPS

header('Content-Type: text/plain');
error_reporting(E_ERROR | E_PARSE);
ini_set('log_errors', 1);
ini_set('display_errors', 0);
date_default_timezone_set('UTC');
set_time_limit(0);

// ========== LOG DE ERRORES PHP PERSONALIZADO ==========
ini_set('error_log', __DIR__ . '/php_error_backend.log');
ini_set('display_errors', 0); // No mostrar al cliente


$LOG_FILE = __DIR__ . '/eventos_wialon2.log';

// ---------------------- CONFIGURACIÓN MYSQL ----------------------
$mysqli = new mysqli("db5018846436.hosting-data.io", "dbu974452", "testera32.", "dbs14878639"); // Cambiar si usas otro nombre de DB



if ($mysqli->connect_error) {
    file_put_contents($LOG_FILE, "[" . date('Y-m-d H:i:s') . "] ERROR MYSQL: " . $mysqli->connect_error . "\n", FILE_APPEND);
    http_response_code(500);
    exit;
}

// ---------------------- CREAR TABLA SI NO EXISTE ----------------------

// ---------------------- ENTRADA EVENTO ----------------------
$data = $_REQUEST;

if (!isset($data['unidad'], $data['evento'], $data['unitid'])) {
    file_put_contents($LOG_FILE, "[" . date('Y-m-d H:i:s') . "] FALTAN PARAMS: " . json_encode($data) . "\n", FILE_APPEND);
    http_response_code(204);
    exit;
}

$unidad    = $mysqli->real_escape_string($data['unidad']);
$unit_id   = $mysqli->real_escape_string($data['unitid']);
$eventoRaw = $mysqli->real_escape_string($data['evento']);
$timestamp = isset($data['timestamp']) ? (int)$data['timestamp'] : time();
$geocerca  = isset($data['geocerca']) ? $mysqli->real_escape_string($data['geocerca']) : null;

$log = "[" . date('Y-m-d H:i:s') . "] Unidad:$unidad | unit_id:$unit_id | evento:$eventoRaw\n";
file_put_contents($LOG_FILE, $log, FILE_APPEND);

// ---------------------- ASEGURAR EXISTENCIA UNIT ----------------------
$result = $mysqli->query("SELECT id FROM units WHERE unit_id = '$unit_id'");
if ($result->num_rows == 0) {
    $mysqli->query("INSERT INTO units (unit_id, unit_name) VALUES ('$unit_id', '$unidad')");
}

// NORMALIZAR EVENTO
$evNorm = mb_strtolower($eventoRaw, 'UTF-8');

// ---------------------- IGNICIÓN ENCENDIDA ----------------------
if (preg_match('/ignici[oó]n\s+encendid/u', $evNorm)) {
    $mysqli->query("UPDATE units SET ignicion='ENCENDIDA', tiempo_ignicion='$timestamp' WHERE unit_id='$unit_id'");

    // ---------------------- IGNICIÓN APAGADA ----------------------
} elseif (preg_match('/ignici[oó]n\s+apag/u', $evNorm)) {
    $mysqli->query("UPDATE units SET ignicion='APAGADA', tiempo_ignicion='$timestamp' WHERE unit_id='$unit_id'");

    // ---------------------- ENTRÓ A GEOCERCA ----------------------
} elseif (preg_match('/entr[oó].*geocerc/u', $evNorm)) {
    if (!$geocerca) $geocerca = 'GEOCERCA';
    $mysqli->query("UPDATE units SET geocercas='$geocerca' WHERE unit_id='$unit_id'");

    // ---------------------- SALIÓ DE GEOCERCA ----------------------a
} elseif (preg_match('/sal/i', $evNorm) && preg_match('/geocerc/i', $evNorm)) {
    $mysqli->query("UPDATE units SET geocercas=NULL WHERE unit_id='$unit_id'");
} else {
    file_put_contents($LOG_FILE, "[" . date('Y-m-d H:i:s') . "] EVENTO NO MANEJADO: $eventoRaw\n", FILE_APPEND);
    http_response_code(204);
    exit;
}

http_response_code(204);
exit;
