<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

$db_host = 'db5018846436.hosting-data.io';
$db_user = 'dbu974452';
$db_pass = 'testera32.';
$db_name = 'dbs14878639';

$mysqli = new mysqli($db_host, $db_user, $db_pass, $db_name);

if ($mysqli->connect_errno) {
    die("❌ Error de conexión MySQL: " . $mysqli->connect_error);
}

// Buscar todos los índices duplicados tipo unit_id_#
$sql = "
    SELECT INDEX_NAME
    FROM information_schema.STATISTICS
    WHERE TABLE_SCHEMA = '$db_name'
      AND TABLE_NAME = 'units'
      AND INDEX_NAME LIKE 'unit_id_%'
";

$result = $mysqli->query($sql);

if ($result && $result->num_rows > 0) {
    $dropStatements = [];
    while ($row = $result->fetch_assoc()) {
        $index = $row['INDEX_NAME'];
        $dropStatements[] = "DROP INDEX `$index`";
    }

    if (!empty($dropStatements)) {
        $alterSQL = "ALTER TABLE `units` " . implode(", ", $dropStatements) . ";";
        echo "🧹 Ejecutando limpieza de índices duplicados...\n";
        if ($mysqli->query($alterSQL)) {
            echo "✅ Se eliminaron los índices duplicados correctamente.\n";
        } else {
            echo "⚠️ Error al eliminar índices: " . $mysqli->error . "\n";
        }
    }
} else {
    echo "ℹ️ No hay índices duplicados tipo unit_id_%.\n";
}

// Verificar si el índice correcto existe
$check = $mysqli->query("SHOW INDEX FROM `units` WHERE Key_name = 'unit_id'");
if ($check->num_rows == 0) {
    echo "⚙️ No existe índice principal unit_id, recreando...\n";
    if ($mysqli->query("ALTER TABLE `units` ADD UNIQUE KEY unit_id (unit_id)")) {
        echo "✅ Índice único 'unit_id' creado correctamente.\n";
    } else {
        echo "❌ Error al crear índice unit_id: " . $mysqli->error . "\n";
    }
} else {
    echo "👍 Índice 'unit_id' principal ya existe, todo OK.\n";
}

$mysqli->close();
?>
